class XHUD extends ChallengeHUD config(User);

#exec TEXTURE IMPORT NAME=Skull FILE=Textures\Skull.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Health FILE=Textures\Health.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Armor FILE=Textures\Armor.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Belt FILE=Textures\Belt.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=BootsOn FILE=Textures\BootsOn.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=InvisNEW FILE=Textures\InvisNEW.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Scuba FILE=Textures\Scuba.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=XDamage FILE=Textures\XDamage.bmp Group=HUD MIPS=ON
//Radar textures:
#exec Texture Import File=Textures\Radar.bmp Name=Radar Group=HUD
#exec Texture Import File=Textures\RadarBorder.bmp Name=RadarBorder Group=HUD
#exec Texture Import File=Textures\Dots.bmp Name=Dots Group=HUD
#exec Texture Import File=Textures\crossm.bmp Name=crossm Group=HUD
//Logo textures:
#exec TEXTURE IMPORT NAME=expl1 FILE=Textures\expl1.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=expl2 FILE=Textures\expl2.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=expl3 FILE=Textures\expl3.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=expl4 FILE=Textures\expl4.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=expl5 FILE=Textures\expl5.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=expl6 FILE=Textures\expl6.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=expl7 FILE=Textures\expl7.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=expl8 FILE=Textures\expl8.bmp Group=HUD MIPS=ON
#exec Texture Import File=Textures\MHXlogo.bmp Name=MHXlogo Group=HUD MIPS=ON
#exec Texture Import File=Textures\MHXlogo_1.bmp Name=MHXlogo_1 Group=HUD MIPS=ON
#exec Texture Import File=Textures\MHXlogo_2.bmp Name=MHXlogo_2 Group=HUD MIPS=ON
#exec Texture Import File=Textures\MHXlogo_3.bmp Name=MHXlogo_3 Group=HUD MIPS=ON
#exec Texture Import File=Textures\MHXlogo_4.bmp Name=MHXlogo_4 Group=HUD MIPS=ON
#exec Texture Import File=Textures\MHXlogo_5.bmp Name=MHXlogo_5 Group=HUD MIPS=ON
#exec Texture Import File=Textures\MHXlogo_6.bmp Name=MHXlogo_6 Group=HUD MIPS=ON
#exec Texture Import File=Textures\utxorg.bmp Name=utxorg Group=HUD MIPS=ON

#exec OBJ LOAD FILE=..\Textures\LadrStatic.utx PACKAGE=Botpack.LadrStatic

var() int SizeY,Count;
var string CurrentMessage;
var float MOTDFadeOutTime;

var float IdentifyFadeTime;
//var PlayerReplicationInfo IdentifyTarget;
var Pawn IdentifyTarget;
var Pawn PawnOwner;	// pawn currently managing this HUD (may be the viewtarget of the owner rather than the owner)
var FontInfo MyFonts;

// Localized Messages
var HUDLocalizedMessage ShortMessageQueue[4];
var HUDLocalizedMessage LocalMessages[10];

var texture FaceTexture;
var float FaceTime;
var color FaceTeam;
 
var() localized string VersionMessage, PlayerCountString;
var localized string MapTitleString, AuthorString;
var localized string MapTitleString2, AuthorString2;

var localized string RankString;
var localized string SpreadString;

var int PlayerCount;
var bool bTiedScore;

var string ReceivedMessage;
var string ReceivedName;
var ZoneInfo ReceivedZone;
var float ReceivedTime;
var texture TutIconTex;
var int TutIconX, TutIconY;
var float TutIconBlink;

var globalconfig int CrosshairCount;
var globalconfig string CrossHairs[20];
var texture CrossHairTextures[20];

var texture GrayWeapons[11];
var texture FP1[3], FP2[3], FP3[3];
var int LastReportedTime;
var bool bStartUpMessage, bForceScores;
var bool bTimeValid;
var bool bLowRes;
var bool bResChanged;
var int OldClipX;

// configuration options
var bool bAlwaysHideFrags, bHideCenterMessages;
var globalconfig bool bHideAllWeapons, bHideStatus, bHideAmmo, bHideTeamInfo, bHideFrags, bHideHUD, bHideNoviceMessages, bHideFaces;
var globalconfig bool bUseTeamColor;
var globalconfig byte Opacity;	// should be between 1 and 16
var globalconfig float HUDScale, StatusScale, WeaponScale;
var globalconfig color FavoriteHUDColor, CrosshairColor;
var float Scale;
var byte Style;
var color BaseColor, WhiteColor, RedColor, GreenColor, CyanColor, UnitColor, BlueColor,
		 GoldColor, HUDColor, SolidHUDColor, PurpleColor, TurqColor, GrayColor, FaceColor, LogoColor;

// Identify Strings
var localized string IdentifyName, IdentifyHealth, IdentifyCallsign;
var localized string LiveFeed;

// scoring 
var float ScoreTime;
var int rank, lead;

// showing damage
var vector HitPos[4];
var float HitTime[4];
var float HitDamage[4];

var float PickupTime;

var float WeaponNameFade;
var float MessageFadeTime;
var int MessageFadeCount;
var bool bDrawMessageArea;
var bool bDrawFaceArea;
var float FaceAreaOffset, MinFaceAreaOffset;
var class<CriticalEventPlus> TimeMessageClass;

// Server info.
var ServerInfo ServerInfo;
var bool bShowInfo;

var class<ServerInfo> ServerInfoClass;

var globalconfig string FontInfoClass;

//custom vars:
var int ArmorAmount, BeltAmount, NumBootsJumps, UDamage, Invis, ScubaGear, DamageAmount;
var bool bUDamage, bTrigger;
var string Ranking;
//radar vars:
var float LastDrawRadar, RadarScale, RadarPosX, RadarPosY, RadarPulse;
var color RadarColor;
//Team Beacon vars:
var float			mMinScale;
var float			mMaxScale;
//Intro Logo variables
var byte Color;
var bool bLogoFadedIn, bLogoFadedOut, bLogoAnimated;
var bool Fire1, Fire2, Fire3, Fire4, Fire5, Fire6;
var int AnimCount, Effcount;
var float IntroDrawScale, IntroX;
var bool bIntroOnPlace, bSetBase, bIntroSound;

function DrawIntroText(Canvas Canvas)
{
local float Xpos, Ypos;

	if (!bSetBase)
		{
		bSetBase = True;
		IntroDrawScale = 15;
		PlayerPawn(Owner).PlaySound (Sound'UnrealI.Generic.Teleport1',,2.0);
		}

	if (!bLogoAnimated)
		{
		Canvas.DrawColor = WhiteColor;
		}
	else
		{
		Canvas.DrawColor.R = Color;
		Canvas.DrawColor.G = Color;
		Canvas.DrawColor.B = Color;
		}

	Canvas.Style = ERenderStyle.STY_Translucent;

	Xpos = Canvas.ClipX * 0.5;
	Ypos = Canvas.ClipY * 0.5 + 32;

	Xpos = Xpos - IntroDrawScale * 128;
	Ypos = Ypos - IntroDrawScale * 64;

	Canvas.SetPos(Xpos, Ypos);
	Canvas.DrawTile(Texture'utxorg', 256 * IntroDrawScale, 64 * IntroDrawScale, 0, 0, 256, 64);

	if ( IntroDrawScale > 1.0 && !bLogoAnimated)
		{
		IntroDrawScale -= 0.2;
		}
	else if (!bIntroSound)
		{
		PlayerPawn(Owner).PlaySound (Sound'UnrealI.Mercenary.land1mr',,2.0);
		bIntroSound = True;
		}
	else if (bLogoAnimated)
		{
		IntroDrawScale += 0.2;
		}
}

function DrawShotFX(Canvas Canvas, float Xpos, float Ypos)
{
	Canvas.DrawColor.R = Color;
	Canvas.DrawColor.G = Color;
	Canvas.DrawColor.B = Color;
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(Xpos, Ypos);

	if ( Effcount < 3 && Effcount > 0 )
		{
		Canvas.DrawIcon(Texture'expl1', 0.35);
		}
	else if ( Effcount < 5 )
		{
		Canvas.DrawIcon(Texture'expl2', 0.35);
		}
	else if ( Effcount < 7 )
		{
		Canvas.DrawIcon(Texture'expl3', 0.35);
		}
	else if ( Effcount < 9 )
		{
		Canvas.DrawIcon(Texture'expl4', 0.35);
		}
	else if ( Effcount < 11 )
		{
		Canvas.DrawIcon(Texture'expl5', 0.35);
		}
	else if ( Effcount < 13)
		{
		Canvas.DrawIcon(Texture'expl6', 0.35);
		}
	else if ( Effcount < 15 )
		{
		Canvas.DrawIcon(Texture'expl7', 0.35);
		}
	else if ( Effcount < 17 )
		{
		Canvas.DrawIcon(Texture'expl8', 0.35);
		}

}

function LogoFadeIn(Canvas Canvas)
{
	Canvas.DrawColor.R = Color;
	Canvas.DrawColor.G = Color;
	Canvas.DrawColor.B = Color;
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 256, Canvas.ClipY * 0.5 - 128);
	Canvas.DrawTile(Texture'MHXlogo', 512, 256, 0, 0, 512, 256);
}

function LogoFadeOut(Canvas Canvas)
{
	Canvas.DrawColor.R = Color;
	Canvas.DrawColor.G = Color;
	Canvas.DrawColor.B = Color;
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 256, Canvas.ClipY * 0.5 - 128);
	Canvas.DrawTile(Texture'MHXlogo_6', 512, 256, 0, 0, 512, 256);
}

function IntroLogo(Canvas Canvas)
{

	DrawIntroText(Canvas);

	//Logo Fade In
	if (Color < 255 && !bLogoFadedIn)
		{
		LogoFadeIn(Canvas);
		Color += 3;
		}
	else
		{
		bLogoFadedIn = True;
		}
	//Animate Logo
	if ( bLogoFadedIn && !bLogoAnimated)
		{
		if ( AnimCount < 50 )
			{
			Canvas.DrawColor.R = Color;
			Canvas.DrawColor.G = Color;
			Canvas.DrawColor.B = Color;
			Canvas.Style = ERenderStyle.STY_Translucent;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 256, Canvas.ClipY * 0.5 - 128);
			Canvas.DrawTile(Texture'MHXlogo', 512, 256, 0, 0, 512, 256);
			}
		else if ( AnimCount < 100 )
			{
			Canvas.DrawColor.R = Color;
			Canvas.DrawColor.G = Color;
			Canvas.DrawColor.B = Color;
			Canvas.Style = ERenderStyle.STY_Translucent;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 256, Canvas.ClipY * 0.5 - 128);
			Canvas.DrawTile(Texture'MHXlogo_1', 512, 256, 0, 0, 512, 256);
			if ( !Fire1 )
				{
				PlayerPawn(Owner).PlaySound (Sound'Botpack.SniperRifle.SniperFire',,2.0);
				Fire1 = True;
				Effcount = 0;
				}
			DrawShotFX(Canvas, Canvas.ClipX * 0.5 - 136, Canvas.ClipY * 0.5 - 124 );
			
			}
		else if ( AnimCount < 150 )
			{
			Canvas.DrawColor.R = Color;
			Canvas.DrawColor.G = Color;
			Canvas.DrawColor.B = Color;
			Canvas.Style = ERenderStyle.STY_Translucent;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 256, Canvas.ClipY * 0.5 - 128);
			Canvas.DrawTile(Texture'MHXlogo_2', 512, 256, 0, 0, 512, 256);
			if ( !Fire2 )
				{
				PlayerPawn(Owner).PlaySound (Sound'Botpack.SniperRifle.SniperFire',,2.0);
				Fire2 = True;
				Effcount = 0;
				}
			DrawShotFX(Canvas, Canvas.ClipX * 0.5 + 150, Canvas.ClipY * 0.5 - 10);
			}
		else if ( AnimCount < 200 )
			{
			Canvas.DrawColor.R = Color;
			Canvas.DrawColor.G = Color;
			Canvas.DrawColor.B = Color;
			Canvas.Style = ERenderStyle.STY_Translucent;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 256, Canvas.ClipY * 0.5 - 128);
			Canvas.DrawTile(Texture'MHXlogo_3', 512, 256, 0, 0, 512, 256);
			if ( !Fire3 )
				{
				PlayerPawn(Owner).PlaySound (Sound'Botpack.SniperRifle.SniperFire',,2.0);
				Fire3 = True;
				Effcount = 0;
				}
			DrawShotFX(Canvas, Canvas.ClipX * 0.5 - 70, Canvas.ClipY * 0.5 + 90);
			}
		else if ( AnimCount < 250 )
			{
			Canvas.DrawColor.R = Color;
			Canvas.DrawColor.G = Color;
			Canvas.DrawColor.B = Color;
			Canvas.Style = ERenderStyle.STY_Translucent;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 256, Canvas.ClipY * 0.5 - 128);
			Canvas.DrawTile(Texture'MHXlogo_4', 512, 256, 0, 0, 512, 256);
			if ( !Fire4 )
				{
				PlayerPawn(Owner).PlaySound (Sound'Botpack.SniperRifle.SniperFire',,2.0);
				Fire4 = True;
				Effcount = 0;
				}
			DrawShotFX(Canvas, Canvas.ClipX * 0.5 - 210, Canvas.ClipY * 0.5 + 20 );
			}
		else if ( AnimCount < 300 )
			{
			Canvas.DrawColor.R = Color;
			Canvas.DrawColor.G = Color;
			Canvas.DrawColor.B = Color;
			Canvas.Style = ERenderStyle.STY_Translucent;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 256, Canvas.ClipY * 0.5 - 128);
			Canvas.DrawTile(Texture'MHXlogo_5', 512, 256, 0, 0, 512, 256);
			if ( !Fire5 )
				{
				PlayerPawn(Owner).PlaySound (Sound'Botpack.SniperRifle.SniperFire',,2.0);
				Fire5 = True;
				Effcount = 0;
				}
			DrawShotFX(Canvas, Canvas.ClipX * 0.5 + 30, Canvas.ClipY * 0.5 - 60 );
			}
		else if ( AnimCount < 500 )
			{
			Canvas.DrawColor.R = Color;
			Canvas.DrawColor.G = Color;
			Canvas.DrawColor.B = Color;
			Canvas.Style = ERenderStyle.STY_Translucent;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 256, Canvas.ClipY * 0.5 - 128);
			Canvas.DrawTile(Texture'MHXlogo_6', 512, 256, 0, 0, 512, 256);
			if ( !Fire6 )
				{
				PlayerPawn(Owner).PlaySound (Sound'Botpack.SniperRifle.SniperFire',,2.0);
				Fire6 = True;
				Effcount = 0;
				}
			DrawShotFX(Canvas, Canvas.ClipX * 0.5 + 200, Canvas.ClipY * 0.5 + 80);
			}
		else if ( AnimCount >= 500 )
			{
			Canvas.DrawColor.R = Color;
			Canvas.DrawColor.G = Color;
			Canvas.DrawColor.B = Color;
			Canvas.Style = ERenderStyle.STY_Translucent;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 256, Canvas.ClipY * 0.5 - 128);
			Canvas.DrawTile(Texture'MHXlogo_6', 512, 256, 0, 0, 512, 256);
			bLogoAnimated = True;
			}
		AnimCount++;
		Effcount++;
		}
	//Logo Fade Out
	if ( bLogoAnimated && Color > 0)
		{
		LogoFadeOut(Canvas);
		Color -= 3;
		}
	else if ( bLogoAnimated && Color == 0)
		{
		bLogoFadedOut = True;
		}
}

function DrawTeamBeacon()
{
	local Pawn 		P;
	local float 	dist;
	local Vector	dir;
	local Vector	loc;
	local byte 		team_id;
	local int		num_used;
	local int 		player_id;
	local int		team_count;
	local int		symbol_count;
	local float		draw_scale;
	local float		interp;
	
	local PlayerReplicationInfo PRI;
	local IdentitySymbol s;

	if (PawnOwner == None)// || !PlayerOwner.Level.Game.bTeamGame)
	{
		return;
	}

	// get the player's information
	team_id = PlayerOwner.PlayerReplicationInfo.Team;
	player_id = PlayerOwner.PlayerReplicationInfo.PlayerID;
	
	num_used = 0;
	team_count = 0;
	symbol_count = 0;
	// count the symbols in the client environment and set them available
	foreach AllActors (class 'IdentitySymbol', s)
	{
		symbol_count++;
		s.bHidden = True; // we use this to set the symbol as 'available' for assignment
	}
	foreach AllActors (class'Pawn', P)
	{
		PRI = P.PlayerReplicationInfo;
		if ( PRI == None )
			continue;
		if ( team_id == PRI.Team && player_id != PRI.PlayerID)
		{
			team_count++;
			if (team_count > symbol_count)// spawn if need more
			{
				s = Spawn(class 'IdentitySymbol', P);
				s.bHidden = P.bHidden;
				s.SetOwner(P);
				symbol_count++;
			}
			else // otherwise, assign a free IdentitySymbol to someone
			{
				foreach AllActors (class 'IdentitySymbol', s)
				{
					if (s.bHidden == True)
					{
						s.bHidden = P.bHidden;
						s.SetOwner(P);
						break;
					}
				}
			}

			// set sprite location above their head
			loc = P.Location;
			loc.z += P.CollisionHeight * 1.75;
			// interp from min/max view distance, to scale the sprite based on distance
			dir = P.Location - PlayerOwner.Location;
			dist = VSize(Dir);
			interp = Dist/32768.0;
		
			// adjust sprite scale if zooming :kludged values:
			interp -= 0.3 * (1.0-(PlayerOwner.FOVAngle / PlayerOwner.DesiredFOV));
			// clamp
			if (interp < 0.0)
				interp = 0.0;
			if (interp > 1.0)
				interp = 1.0;
			draw_scale = Lerp( interp, mMinScale, mMaxScale); 
			s.SetLocation(loc);
			s.DrawScale = draw_scale;
			s.Texture = texture'TeamBeacon';
		}
	}
}

function SetRank(int Score)
{
	// Enlisted:
	if ( Score < 20000 )
		Ranking = "Recruit, No special skills.";
	else if ( Score < 40000 )
		Ranking = "Private, no ammo deducted when hit.";
	else if ( Score < 60000 )
		Ranking = "Corporal, no ammo deducted when hit + 5% damage to health(max300).";
	else if ( Score < 80000 )
		Ranking = "Sergeant, +1 ammo  per hit(max200) + 5% damage to health(max300).";
	else if ( Score < 100000 )
		Ranking = "Staff Sergeant, +1 ammo per hit(max200) + 10% damage to health(max300).";
	else if ( Score < 120000 )
		Ranking = "Sergeant First Class, +2 ammo per hit(max200) + 10% damage to health(max300).";
	else if ( Score < 150000 )
		Ranking = "Master Sergeant, +2 ammo per hit(max200) + 15% damage to health(max300).";
	// Commissioned:
	else if ( Score < 200000 )
		Ranking = "Second Lieutenant, +2 ammo per hit(max250) + 15% damage to health(max300).";
	else if ( Score < 400000 )
		Ranking = "First Lieutenant, +2 ammo per hit(max250) + 15% damage to health(max350).";
	else if ( Score < 800000 )
		Ranking = "Captain, +2 ammo per hit(max250) + 15% damage to health(max400).";
	else if ( Score < 1200000 )
		Ranking = "Major, +2 ammo per hit(max300) + 15% damage to health(max400).";
	else if ( Score < 1800000 )
		Ranking = "Colonel, +3 ammo per hit(max300) + 15% damage to health(max400).";
	else if ( Score < 2400000 )
		Ranking = "1-star General, +3 ammo per hit (max350) + 15% damage to health(max400).";
	else if ( Score < 3000000 )
		Ranking = "2-star General, +3 ammo per hit (max350) + 15% damage to health(max450).";
	else
		Ranking = "Marshal, +3 ammo per hit(max350) + 15% damage to health(max500).";
}

simulated function DrawGameSynopsis(Canvas Canvas)
{
	local float XL, YL, XOffset, YOffset;

	if ( (PawnOwner.PlayerReplicationInfo == None) 
		|| PawnOwner.PlayerReplicationInfo.bIsSpectator )
		return;

	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.DrawColor = WhiteColor;

	Canvas.StrLen(RankString, XL, YL);
	YOffset = Canvas.ClipY - 64 - YL*3;
	if (MonsterReplicationInfo(PlayerPawn(Owner).GameReplicationInfo).bUseLives)
	{
		Canvas.SetPos(1, YOffset);
		Canvas.DrawText("Lives: "$int(PawnOwner.PlayerReplicationInfo.Deaths), False);
	}
	Canvas.SetPos(1, YOffset + YL);
	Canvas.DrawText("Hunters: "$string(MonsterReplicationInfo(PlayerPawn(Owner).GameReplicationInfo).Hunters), False);
	Canvas.SetPos(1, YOffset + YL + YL);
	Canvas.DrawText("Monsters: "$string(MonsterReplicationInfo(PlayerPawn(Owner).GameReplicationInfo).Monsters), False);
}

function Destroyed()
{
	Super.Destroyed();
	if ( MyFonts != None )
		MyFonts.Destroy();
}

function SetDamage(vector HitLoc, float damage)
{
	local int i, best;
	local vector X,Y,Z;
	local float Max, XOffset, YOffset;

	if ( Level.bDropDetail || !PlayerOwner.IsA('TournamentPlayer') )
		return;

	for ( i=0; i<4; i++ )
		if ( Level.TimeSeconds - HitTime[i] > Max )
		{
			best = i;	
			Max = Level.TimeSeconds - HitTime[i];
		}

	HitTime[best] = Level.TimeSeconds;
	HitDamage[best] = FClamp(Damage * 0.06,2,4);
	GetAxes(Owner.Rotation,X,Y,Z);
	XOffset = - 0.5 * FClamp((Y Dot HitLoc)/CollisionRadius , -1, 1);
	YOffset = -0.5 * FClamp((Z Dot HitLoc)/CollisionHeight , -1, 1);

	// hack for positions around head or near legs
	if ( YOffset < -0.35 )
	{
		XOffset *= 0.3;
		YOffset = FMax(HitPos[best].Y, -0.45);
	}
	else if ( YOffset > 0.1 )
	{
		if ( abs(XOffset) < 0.25 )
		{
			if ( XOffset > 0 )
				XOffset = 0.25;
			else
				XOffset = -0.25;
		}				
		YOffset = FMin(YOffset, 0.4);
	}

	HitPos[best].X = 128 * (0.5 + XOffset) - 0.5 * 25 * HitDamage[best];
	HitPos[best].Y = 256 * (0.5 + YOffset) - 0.5 * HitDamage[Best] * 64;
}

simulated function PostBeginPlay()
{
	local int i;

	if ( Level.NetMode != NM_Standalone )
		MOTDFadeOutTime = 350;
	FaceAreaOffset = -64;
	MyFonts = FontInfo(spawn(Class<Actor>(DynamicLoadObject(FontInfoClass, class'Class'))));
	Super.PostBeginPlay();
	SetTimer(1.0, True);

	if ( (PlayerPawn(Owner).GameReplicationInfo != None)
		&& (PlayerPawn(Owner).GameReplicationInfo.RemainingTime > 0) )
		TimeMessageClass = class<CriticalEventPlus>(DynamicLoadObject("Botpack.TimeMessage", class'Class'));

	ServerInfo = Spawn(ServerInfoClass, Owner);
}

exec function SetHUDR(int n)
{
	FavoriteHUDColor.R = Clamp(n,0,16);
}

exec function SetHUDG(int n)
{
	FavoriteHUDColor.G = Clamp(n,0,16);
}

exec function SetHUDB(int n)
{
	FavoriteHUDColor.B = Clamp(n,0,16);
}

exec function ShowServerInfo()
{
	if (bShowInfo)
	{
		bShowInfo = False;
	} else {
		bShowInfo = True;
		PlayerPawn(Owner).bShowScores = False;
	}
}

exec function GrowHUD()
{
	if ( bHideHUD )
		bHideHud = false;
	else if ( bHideAmmo )
		bHideAmmo = false;
	else if ( bHideFrags )
		bHideFrags = false;
	else if ( bHideTeamInfo )
		bHideTeamInfo = false;
	else if ( bHideAllWeapons )
		bHideAllWeapons = false;
	else if ( bHideStatus )
		bHideStatus = false;
	else 
		WeaponScale = 1.0;

	SaveConfig();
}

exec function ShrinkHUD()
{
	if ( !bLowRes && (WeaponScale * HUDScale > 0.8) )
		WeaponScale = 0.8/HUDScale;
	else if ( !bHideStatus )
		bHideStatus = true;
	else if ( !bHideAllWeapons )
		bHideAllWeapons = true;
	else if ( !bHideTeamInfo )
		bHideTeamInfo = true;
	else if ( !bHideFrags )
		bHideFrags = true;
	else if ( !bHideAmmo )
		bHideAmmo = true;
	else
		bHideHud = true;

	SaveConfig();
}
	
simulated function ChangeCrosshair(int d)
{
	Crosshair = Crosshair + d;
	if ( Crosshair >= CrossHairCount )
		Crosshair = 0;
	else
	if ( Crosshair < 0 )
		Crosshair = CrossHairCount-1;
}

simulated function Texture LoadCrosshair(int c)
{
	CrossHairTextures[c] = Texture(DynamicLoadObject(CrossHairs[c], class'Texture'));
	return CrossHairTextures[c];
}

simulated function HUDSetup(canvas canvas)
{
	local int FontSize;

	bResChanged = (Canvas.ClipX != OldClipX);
	OldClipX = Canvas.ClipX;
		
	PlayerOwner = PlayerPawn(Owner);
	if ( PlayerOwner.ViewTarget == None )
		PawnOwner = PlayerOwner;
	else if ( PlayerOwner.ViewTarget.bIsPawn )
		PawnOwner = Pawn(PlayerOwner.ViewTarget);
	else 
		PawnOwner = PlayerOwner;

	// Setup the way we want to draw all HUD elements
	Canvas.Reset();
	Canvas.SpaceX=0;
	Canvas.bNoSmooth = True;

	FontSize = Min(3, HUDScale * Canvas.ClipX/500);
	Scale = (HUDScale * Canvas.ClipX)/1280.0;

	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );

	SolidHUDColor = FavoriteHUDColor * 15.9;
	if ( (Opacity == 16) || !Level.bHighDetailMode )
	{
		Style = ERenderStyle.STY_Normal;
		BaseColor = WhiteColor;
		HUDColor = SolidHUDColor;
	}
	else
	{
		Style = ERenderStyle.STY_Translucent;
		BaseColor = (16 * Opacity + 15) * UnitColor;
		HUDColor = FavoriteHUDColor * (Opacity + 0.9);
	}
	Canvas.DrawColor = BaseColor;
	Canvas.Style = Style;
	bLowRes = ( Canvas.ClipX < 400 );
	if ( bLowRes )
		WeaponScale = 1.0;
}

simulated function DrawDigit(Canvas Canvas, int d, int Step, float UpScale, out byte bMinus )
{
	if ( bMinus == 1 )
	{
		Canvas.CurX -= Step;
		Canvas.DrawTile(Texture'BotPack.HudElements1', UpScale*25, 64*UpScale, 0, 64, 25.0, 64.0);
		bMinus = 0;
	}
	if ( d == 1 )
		Canvas.CurX -= 0.625 * Step;
	else
		Canvas.CurX -= 0.25 * Step;		
	Canvas.DrawTile(Texture'BotPack.HudElements1', UpScale*25, 64*UpScale, d*25, 0, 25.0, 64.0);
	Canvas.CurX += 7*UpScale;
}

// DrawBigNum should already have Canvas set up
// X and Y should be the left most allowed position of the number (will be adjusted right if possible)
simulated function DrawBigNum(Canvas Canvas, int Value, int X, int Y, optional float ScaleFactor)
{
	local int d, Mag, Step;
	local float UpScale;
	local byte bMinus;

	if ( ScaleFactor != 0 )
		UpScale = Scale * ScaleFactor;
	else
		UpScale = Scale;

	Canvas.CurX = X;	
	Canvas.CurY = Y;
	Step = 16 * UpScale;
	if ( Value < 0 )
		bMinus = 1;
	Mag = FMin(9999, Abs(Value));

	if ( Mag >= 1000 )
	{
		Canvas.CurX -= Step;
		d = 0.001 * Mag;
		DrawDigit(Canvas, d, Step, UpScale, bMinus);
		Mag = Mag - 1000 * d;
		d = 0.01 * Mag;
		DrawDigit(Canvas, d, Step, UpScale, bMinus);
		Mag = Mag - 100 * d;
	}
	else if ( Mag >= 100 )
	{
		d = 0.01 * Mag;
		DrawDigit(Canvas, d, Step, UpScale, bMinus);
		Mag = Mag - 100 * d;
	}
	else
		Canvas.CurX += Step;

	if ( Mag >= 10 )
	{
		d = 0.1 * Mag;
		DrawDigit(Canvas, d, Step, UpScale, bMinus);
		Mag = Mag - 10 * d;
	}
	else if ( d > 0 )
		DrawDigit(Canvas, 0, Step, UpScale, bMinus);
	else
		Canvas.CurX += Step;

	DrawDigit(Canvas, Mag, Step, UpScale, bMinus);
}

//rebuild to display the Armor, shieldbelt & Jumpboots charge:
simulated function DrawStatus(Canvas Canvas)
{
local Inventory Inv;
local int YPos;
local float XL, YL;


	ArmorAmount = 0;
	BeltAmount = 0;
	NumBootsJumps = 0;
	Invis = 0;

	for( Inv=PawnOwner.Inventory; Inv!=None; Inv=Inv.Inventory )
		{ 
		if ( Inv.IsA('UT_Shieldbelt') )
			{
			BeltAmount += Inv.Charge;
			}
		else if ( Inv.IsA('Armor2') || Inv.IsA('ThighPads') || Inv.IsA('KevlarSuit') || Inv.IsA('AsbestosSuit') || Inv.IsA('ToxinSuit'))
			{
			ArmorAmount += Inv.Charge;
			}

		else if ( Inv.IsA('UT_JumpBoots') )
			{
			NumBootsJumps = Inv.Charge;
			}
		else if ( Inv.IsA('UT_invisibility'))
			{
			Invis = Inv.Charge;
			}
		else if ( Inv.IsA('SCUBAGear'))
			{
			ScubaGear = Inv.Charge;
			}
		else if ( Inv.IsA('XCrade_Damage'))
			{
			DamageAmount = Inv.Charge;
			}
		}

	if ( PawnOwner.PlayerReplicationInfo == None )
		return;

	Canvas.DrawColor = WhiteColor;

	//items are only drawn if the player has them:

	YPos = Canvas.ClipY;
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );

	//Draw Boots
	if (NumBootsJumps > 0)
		{
		YPos -= 32;
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.SetPos(Canvas.ClipX - 32, Ypos);
		Canvas.StrLen(NumBootsJumps, XL, YL);
		Canvas.DrawTile(Texture'BootsOn', 32, 32, 0, 0, 32, 32);
		Canvas.Style = Style;
		Canvas.SetPos(Canvas.ClipX - 34 - XL, Ypos + 8);
		Canvas.DrawText(NumBootsJumps, False);
		}
	
	//Draw Armor
	if (ArmorAmount > 0 && BeltAmount <= 0)
		{
		YPos -= 32;
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.SetPos(Canvas.ClipX - 32, Ypos);
		Canvas.StrLen(ArmorAmount, XL, YL);
		Canvas.DrawTile(Texture'Armor', 32, 32, 0, 0, 32, 32);
		Canvas.Style = Style;
		Canvas.SetPos(Canvas.ClipX - 34 - XL, Ypos + 8);
		Canvas.DrawText(ArmorAmount, False);
		}

	//Draw Belt
	if (BeltAmount > 0)
		{
		YPos -= 32;
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.SetPos(Canvas.ClipX - 32, Ypos);
		Canvas.StrLen(BeltAmount, XL, YL);
		Canvas.DrawTile(Texture'Belt', 32, 32, 0, 0, 32, 32);
		Canvas.Style = Style;
		Canvas.SetPos(Canvas.ClipX - 34 - XL, Ypos + 8);
		Canvas.DrawText(BeltAmount, False);
		}

	//Draw Invis
	if (Invis > 0)
		{
		YPos -= 32;
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.SetPos(Canvas.ClipX - 32, Ypos);
		Canvas.StrLen(Invis, XL, YL);
		Canvas.DrawTile(Texture'InvisNEW', 32, 32, 0, 0, 32, 32);
		Canvas.Style = Style;
		Canvas.SetPos(Canvas.ClipX - 34 - XL, Ypos + 8);
		Canvas.DrawText(Invis, False);
		}


	//Draw ScubaGear
	if (ScubaGear > 0)
		{
		YPos -= 32;
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.SetPos(Canvas.ClipX - 32, Ypos);
		Canvas.StrLen(ScubaGear, XL, YL);
		Canvas.DrawTile(Texture'Scuba', 32, 32, 0, 0, 32, 32);
		Canvas.Style = Style;
		Canvas.SetPos(Canvas.ClipX - 34 - XL, Ypos + 8);
		Canvas.DrawText(ScubaGear, False);
		}
	//Draw XDamage
	if (DamageAmount > 0)
		{
		YPos -= 32;
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.SetPos(Canvas.ClipX - 32, Ypos);
		Canvas.StrLen(DamageAmount, XL, YL);
		Canvas.DrawTile(Texture'XDamage', 32, 32, 0, 0, 32, 32);
		Canvas.Style = Style;
		Canvas.SetPos(Canvas.ClipX - 34 - XL, Ypos + 8);
		Canvas.DrawText(DamageAmount, False);
		}
}

simulated function DrawAmmo(Canvas Canvas)
{

}

simulated function DrawFragCount(Canvas Canvas)
{
	local int X,Y;

	if ( PawnOwner.PlayerReplicationInfo == None )
		return;

	SetRank(PawnOwner.PlayerReplicationInfo.Score);

	Canvas.DrawColor = WhiteColor; 

	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(0, Canvas.ClipY - 32);
	Canvas.DrawTile(Texture'Skull', 32, 32, 0, 0, 32, 32);

	Canvas.Style = Style;
	Canvas.SetPos(34, Canvas.ClipY - 24);
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.DrawText(int(PawnOwner.PlayerReplicationInfo.Score)$", Ranking as:"@Ranking, False);

}

simulated function DrawHealth(Canvas Canvas)
{
	local int X,Y;

	if ( PawnOwner.PlayerReplicationInfo == None )
		return;

	Canvas.DrawColor = WhiteColor; 

	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(0, Canvas.ClipY - 64);
	Canvas.DrawTile(Texture'Health', 32, 32, 0, 0, 32, 32);

	Canvas.Style = Style;
	Canvas.SetPos(34, Canvas.ClipY - 56);
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.DrawText(PawnOwner.Health, False);

}

simulated function DrawWeapons(Canvas Canvas)
{
local float XL, YL;

	
	if ( PawnOwner.Weapon.ItemName != "" && PawnOwner.Weapon != None )
		{
		Canvas.bCenter=True;
		Canvas.DrawColor = WhiteColor;
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
		if ( PawnOwner.Weapon.AmmoType.AmmoAmount != 0 )
			{
			Canvas.StrLen(PawnOwner.Weapon.ItemName$" - Ammo: "@PawnOwner.Weapon.AmmoType.AmmoAmount, XL, YL);
			Canvas.SetPos(0, Canvas.ClipY - YL * 2);
			Canvas.DrawText(PawnOwner.Weapon.ItemName$" - Ammo: "@PawnOwner.Weapon.AmmoType.AmmoAmount, False);
			}
		else
			{
			Canvas.StrLen(PawnOwner.Weapon.ItemName, XL, YL);
			Canvas.SetPos(0, Canvas.ClipY - YL * 2);
			Canvas.DrawText(PawnOwner.Weapon.ItemName, False);
			}

		Canvas.bCenter=False;
		}
	//Set WarHeadLauncher so it doesn't increase ammo
	if ( PawnOwner.Weapon.ItemName == "Redeemer" && PawnOwner.Weapon.AmmoType.AmmoAmount > 1 )
		{
		PawnOwner.Weapon.AmmoType.AmmoAmount = 1;
		}
}

simulated function DisplayProgressMessage( canvas Canvas )
{
	local int i;
	local float XL, YL, YOffset;
	local GameReplicationInfo GRI;

	PlayerOwner.ProgressTimeOut = FMin(PlayerOwner.ProgressTimeOut, Level.TimeSeconds + 8);
	Canvas.Style = ERenderStyle.STY_Normal;	

	Canvas.bCenter = True;
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.StrLen("TEST", XL, YL);
	if ( UTIntro(Level.Game) != None )
		YOffset = 64 * scale + 2 * YL;
	else if ( (MOTDFadeOutTime <= 0) || (Canvas.ClipY < 300) )
		YOffset = 64 * scale + 6 * YL;
	else
	{
		YOffset = 64 * scale + 6 * YL;
		GRI = PlayerOwner.GameReplicationInfo;
		if ( GRI != None )
		{
			if ( GRI.MOTDLine1 != "" )
				YOffset += YL;
			if ( GRI.MOTDLine2 != "" )
				YOffset += YL;
			if ( GRI.MOTDLine3 != "" )
				YOffset += YL;
			if ( GRI.MOTDLine4 != "" )
				YOffset += YL;
		}
	}
	for (i=0; i<8; i++)
	{
		Canvas.SetPos(0, YOffset);
		Canvas.DrawColor = PlayerPawn(Owner).ProgressColor[i];
		Canvas.DrawText(PlayerPawn(Owner).ProgressMessage[i], False);
		YOffset += YL + 1;
	}
	Canvas.DrawColor = WhiteColor;
	Canvas.bCenter = False;
	HUDSetup(Canvas);	
}

function DrawTalkFace(Canvas Canvas, int i, float YPos)
{
	if ( !bHideHUD && !PawnOwner.PlayerReplicationInfo.bIsSpectator )
	{
		Canvas.DrawColor = WhiteColor;
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.SetPos(FaceAreaOffset + 4*Scale, 4*Scale);
		Canvas.DrawTile(FaceTexture, YPos - 1*Scale, YPos - 1*Scale, 0, 0, FaceTexture.USize, FaceTexture.VSize);
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.DrawColor = FaceColor;
		Canvas.SetPos(FaceAreaOffset, 0);
		Canvas.DrawTile(texture'LadrStatic.Static_a00', YPos + 7*Scale, YPos + 7*Scale, 0, 0, texture'LadrStatic.Static_a00'.USize, texture'LadrStatic.Static_a00'.VSize);
		Canvas.DrawColor = WhiteColor;
	}
}

function bool DrawSpeechArea( Canvas Canvas, float XL, float YL )
{
	local float YPos, Yadj;
	local float WackNumber;
	local int paneltype;

	YPos = FMax(YL*4 + 8, 70*Scale);
	Yadj = YPos + 7*Scale;
	YPos *=2;
	MinFaceAreaOffset = -1 * Yadj;
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = HUDColor * MessageFadeTime;

	Canvas.SetPos(FaceAreaOffset, 0);
	Canvas.DrawTile(texture'LadrStatic.Static_a00', Yadj, Yadj, 0, 0, texture'LadrStatic.Static_a00'.USize, texture'LadrStatic.Static_a00'.VSize);

	WackNumber = 512*Scale - 64 + FaceAreaOffset; // 256*Scale - (512*Scale - (768*Scale - 64 + FaceAreaOffset));
	if ( !PlayerOwner.Player.Console.bTyping )
		paneltype = 0;
	else 
	{
		Canvas.StrLen("(>"@PlayerOwner.Player.Console.TypedStr$"_", XL, YL);
		if (XL < 768*Scale)
			paneltype = 1;
		else 
			paneltype = 2;
	}

	Canvas.SetPos(Yadj + FaceAreaOffset, 0);
	Canvas.DrawTile(FP1[paneltype], 256*Scale - FaceAreaOffset, YPos, 0, 0, FP1[paneltype].USize, FP1[paneltype].VSize);

	Yadj += 256 * Scale;
	Canvas.SetPos(Yadj, 0);
	Canvas.DrawTile(FP2[paneltype], WackNumber, YPos, 0, 0, FP2[paneltype].USize, FP2[paneltype].VSize);

	Canvas.SetPos(Yadj + WackNumber, 0);
	Canvas.DrawTile(FP3[paneltype], 64, YPos, 0, 0, FP3[paneltype].USize, FP3[paneltype].VSize);
}

//========================================
// Master HUD render function.

simulated function PostRender( canvas Canvas )
{
	local float XL, YL, XPos, YPos, FadeValue;
	local string Message;
	local int M, i, j, k, XOverflow;
	local float OldOriginX;

	if ( !bLogoFadedOut)
		{
		IntroLogo(Canvas);
		return;
		}

	HUDSetup(canvas);
	if ( (PawnOwner == None) || (PlayerOwner.PlayerReplicationInfo == None) )
		return;

	if ( bShowInfo )
	{
		ServerInfo.RenderInfo( Canvas );
		return;
	}

	

	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	OldOriginX = Canvas.OrgX;
	// Master message short queue control loop.
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.StrLen("TEST", XL, YL);
	Canvas.SetClip(768*Scale - 10, Canvas.ClipY);
	bDrawFaceArea = false;
	if ( !bHideFaces && !PlayerOwner.bShowScores && !bForceScores && !bHideHUD 
			&& !PawnOwner.PlayerReplicationInfo.bIsSpectator && (Scale >= 0.4) )
	{
		DrawSpeechArea(Canvas, XL, YL);
		bDrawFaceArea = (FaceTexture != None) && (FaceTime > Level.TimeSeconds);
		if ( bDrawFaceArea )
		{
			if ( !bHideHUD && ((PawnOwner.PlayerReplicationInfo == None) || !PawnOwner.PlayerReplicationInfo.bIsSpectator) )
				Canvas.SetOrigin( FMax(YL*4 + 8, 70*Scale) + 7*Scale + 6 + FaceAreaOffset, Canvas.OrgY );
		}
	}

	for (i=0; i<4; i++)
	{
		if ( ShortMessageQueue[i].Message != None )
		{
			j++;

			if ( bResChanged || (ShortMessageQueue[i].XL == 0) )
			{
				if ( ShortMessageQueue[i].Message.Default.bComplexString )
					Canvas.StrLen(ShortMessageQueue[i].Message.Static.AssembleString( 
											self,
											ShortMessageQueue[i].Switch,
											ShortMessageQueue[i].RelatedPRI,
											ShortMessageQueue[i].StringMessage), 
								   ShortMessageQueue[i].XL, ShortMessageQueue[i].YL);
				else
					Canvas.StrLen(ShortMessageQueue[i].StringMessage, ShortMessageQueue[i].XL, ShortMessageQueue[i].YL);
				Canvas.StrLen("TEST", XL, YL);
				ShortMessageQueue[i].numLines = 1;
				if ( ShortMessageQueue[i].YL > YL )
				{
					ShortMessageQueue[i].numLines++;
					for (k=2; k<4-i; k++)
					{
						if (ShortMessageQueue[i].YL > YL*k)
							ShortMessageQueue[i].numLines++;
					}
				}
			}

			// Keep track of the amount of lines a message overflows, to offset the next message with.
			Canvas.SetPos(6, 2 + YL * YPos);
			YPos += ShortMessageQueue[i].numLines;
			if ( YPos > 4 )
				break; 

			if ( ShortMessageQueue[i].Message.Default.bComplexString )
			{
				// Use this for string messages with multiple colors.
				ShortMessageQueue[i].Message.Static.RenderComplexMessage( 
					Canvas,
					ShortMessageQueue[i].XL,  YL,
					ShortMessageQueue[i].StringMessage,
					ShortMessageQueue[i].Switch,
					ShortMessageQueue[i].RelatedPRI,
					None,
					ShortMessageQueue[i].OptionalObject
					);				
			} 
			else
			{
				Canvas.DrawColor = ShortMessageQueue[i].Message.Default.DrawColor;
				Canvas.DrawText(ShortMessageQueue[i].StringMessage, False);
			}
		}
	}

	Canvas.DrawColor = WhiteColor;
	Canvas.SetClip(OldClipX, Canvas.ClipY);
	Canvas.SetOrigin(OldOriginX, Canvas.OrgY);

	if ( PlayerOwner.bShowScores || bForceScores )
	{
		if ( (PlayerOwner.Scoring == None) && (PlayerOwner.ScoringType != None) )
			PlayerOwner.Scoring = Spawn(PlayerOwner.ScoringType, PlayerOwner);
		if ( PlayerOwner.Scoring != None )
		{ 
			PlayerOwner.Scoring.OwnerHUD = self;
			PlayerOwner.Scoring.ShowScores(Canvas);
			if ( PlayerOwner.Player.Console.bTyping )
				DrawTypingPrompt(Canvas, PlayerOwner.Player.Console);
			return;
		}
	}

	YPos = FMax(YL*4 + 8, 70*Scale);
	if ( bDrawFaceArea )
		DrawTalkFace( Canvas,0, YPos );
	if (j > 0) 
	{
		bDrawMessageArea = True;
		MessageFadeCount = 2;
	} 
	else 
		bDrawMessageArea = False;

	if ( !bHideCenterMessages )
	{
		// Master localized message control loop.
		for (i=0; i<10; i++)
		{
			if (LocalMessages[i].Message != None)
			{
				if (LocalMessages[i].Message.Default.bFadeMessage && Level.bHighDetailMode)
				{
					Canvas.Style = ERenderStyle.STY_Translucent;
					FadeValue = (LocalMessages[i].EndOfLife - Level.TimeSeconds);
					if (FadeValue > 0.0)
					{
						if ( bResChanged || (LocalMessages[i].XL == 0) )
						{
							if ( LocalMessages[i].Message.Static.GetFontSize(LocalMessages[i].Switch) == 1 )
								LocalMessages[i].StringFont = MyFonts.GetBigFont( Canvas.ClipX );
							else // ==2
								LocalMessages[i].StringFont = MyFonts.GetHugeFont( Canvas.ClipX );
							Canvas.Font = LocalMessages[i].StringFont;
							Canvas.StrLen(LocalMessages[i].StringMessage, LocalMessages[i].XL, LocalMessages[i].YL);
							LocalMessages[i].YPos = LocalMessages[i].Message.Static.GetOffset(LocalMessages[i].Switch, LocalMessages[i].YL, Canvas.ClipY);
						}
						Canvas.Font = LocalMessages[i].StringFont;
						Canvas.DrawColor = LocalMessages[i].DrawColor * (FadeValue/LocalMessages[i].LifeTime);
						Canvas.SetPos( 0.5 * (Canvas.ClipX - LocalMessages[i].XL), LocalMessages[i].YPos );
						Canvas.DrawText( LocalMessages[i].StringMessage, False );
					}
				} 
				else 
				{
					if ( bResChanged || (LocalMessages[i].XL == 0) )
					{
						if ( LocalMessages[i].Message.Static.GetFontSize(LocalMessages[i].Switch) == 1 )
							LocalMessages[i].StringFont = MyFonts.GetBigFont( Canvas.ClipX );
						else // == 2
							LocalMessages[i].StringFont = MyFonts.GetHugeFont( Canvas.ClipX );
						Canvas.Font = LocalMessages[i].StringFont;
						Canvas.StrLen(LocalMessages[i].StringMessage, LocalMessages[i].XL, LocalMessages[i].YL);
						LocalMessages[i].YPos = LocalMessages[i].Message.Static.GetOffset(LocalMessages[i].Switch, LocalMessages[i].YL, Canvas.ClipY);
					}
					Canvas.Font = LocalMessages[i].StringFont;
					Canvas.Style = ERenderStyle.STY_Normal;
					Canvas.DrawColor = LocalMessages[i].DrawColor;
					Canvas.SetPos( 0.5 * (Canvas.ClipX - LocalMessages[i].XL), LocalMessages[i].YPos );
					Canvas.DrawText( LocalMessages[i].StringMessage, False );
				}
			}
		}
	}
	Canvas.Style = ERenderStyle.STY_Normal;

	if ( !PlayerOwner.bBehindView && (PawnOwner.Weapon != None) && (Level.LevelAction == LEVACT_None) )
	{
		Canvas.DrawColor = WhiteColor;
		PawnOwner.Weapon.PostRender(Canvas);
		if ( !PawnOwner.Weapon.bOwnsCrossHair )
			DrawCrossHair(Canvas, 0,0 );
	}

	if ( (PawnOwner != Owner) && PawnOwner.bIsPlayer )
	{
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		Canvas.bCenter = true;
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.DrawColor = CyanColor * TutIconBlink;
		Canvas.SetPos(4, Canvas.ClipY - 96 * Scale);
		Canvas.DrawText( LiveFeed$PawnOwner.PlayerReplicationInfo.PlayerName, true );
		Canvas.bCenter = false;
		Canvas.DrawColor = WhiteColor;
		Canvas.Style = Style;
	}


	if ( bStartUpMessage && (Level.TimeSeconds < 5) )
	{
		bStartUpMessage = false;
		PlayerOwner.SetProgressTime(7);
	}

	if ( (PlayerOwner.ProgressTimeOut > Level.TimeSeconds) && !bHideCenterMessages)
		DisplayProgressMessage(Canvas);

	// Display MOTD
	if ( MOTDFadeOutTime > 0.0 )
		DrawMOTD(Canvas);
		 
	if( !bHideHUD )
	{
		if ( !PawnOwner.PlayerReplicationInfo.bIsSpectator )
		{
			Canvas.Style = Style;

			// Draw Ammo
			if ( !bHideAmmo )
				DrawAmmo(Canvas);
			
			// Draw Health/Armor status
			DrawStatus(Canvas);

			// Display Weapons
			if ( !bHideAllWeapons )
				DrawWeapons(Canvas);
			else if ( Level.bHighDetailMode
					&& (PawnOwner == PlayerOwner) && (PlayerOwner.Handedness == 2) )
			{
				// if weapon bar hidden and weapon hidden, draw weapon name when it changes
				if ( PawnOwner.PendingWeapon != None )
				{
					WeaponNameFade = 1.0;
					Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
					Canvas.DrawColor = PawnOwner.PendingWeapon.NameColor;
					Canvas.SetPos(Canvas.ClipX - 360 * Scale, Canvas.ClipY - 64 * Scale);
					Canvas.DrawText(PawnOwner.PendingWeapon.ItemName, False);
				}
				else if ( (Level.NetMode == NM_Client)  
						&& PawnOwner.IsA('TournamentPlayer') && (TournamentPlayer(PawnOwner).ClientPending != None) )
				{
					WeaponNameFade = 1.0;
					Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
					Canvas.DrawColor = TournamentPlayer(PawnOwner).ClientPending.NameColor;
					Canvas.SetPos(Canvas.ClipX - 360 * Scale, Canvas.ClipY - 64 * Scale);
					Canvas.DrawText(TournamentPlayer(PawnOwner).ClientPending.ItemName, False);
				}
				else if ( (WeaponNameFade > 0) && (PawnOwner.Weapon != None) )
				{
					Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
					Canvas.DrawColor = PawnOwner.Weapon.NameColor;
					if ( WeaponNameFade < 1 )
						Canvas.DrawColor = Canvas.DrawColor * WeaponNameFade;
					Canvas.SetPos(Canvas.ClipX - 360 * Scale, Canvas.ClipY - 64 * Scale);
					Canvas.DrawText(PawnOwner.Weapon.ItemName, False);
				}
			}
		//DrawCustom		
		DrawFragCount(Canvas);
		DrawHealth(Canvas);
		DrawTimeInfo(Canvas);
		DrawRadar(Canvas);
		DrawTeamBeacon();
		}

		DrawGameSynopsis(Canvas);

		// Display Identification Info
		if ( PawnOwner == PlayerOwner )
			DrawIdentifyInfo(Canvas);

		if ( HUDMutator != None )
			HUDMutator.PostRender(Canvas);

		if ( (PlayerOwner.GameReplicationInfo != None) && (PlayerPawn(Owner).GameReplicationInfo.RemainingTime > 0) ) 
		{
			if ( TimeMessageClass == None )
				TimeMessageClass = class<CriticalEventPlus>(DynamicLoadObject("Botpack.TimeMessage", class'Class'));

			if ( (PlayerOwner.GameReplicationInfo.RemainingTime <= 300)
			  && (PlayerOwner.GameReplicationInfo.RemainingTime != LastReportedTime) )
			{
				LastReportedTime = PlayerOwner.GameReplicationInfo.RemainingTime;
				if ( PlayerOwner.GameReplicationInfo.RemainingTime <= 30 )
				{
					bTimeValid = ( bTimeValid || (PlayerOwner.GameReplicationInfo.RemainingTime > 0) );	
					if ( PlayerOwner.GameReplicationInfo.RemainingTime == 30 )
						TellTime(5);
					else if ( bTimeValid && PlayerOwner.GameReplicationInfo.RemainingTime <= 10 )
						TellTime(16 - PlayerOwner.GameReplicationInfo.RemainingTime);
				}
				else if ( PlayerOwner.GameReplicationInfo.RemainingTime % 60 == 0 )
				{
					M = PlayerOwner.GameReplicationInfo.RemainingTime/60;
					TellTime(5 - M);
				}
			}
		}
	}
	if ( PlayerOwner.Player.Console.bTyping )
		DrawTypingPrompt(Canvas, PlayerOwner.Player.Console);

	if ( PlayerOwner.bBadConnectionAlert && (PlayerOwner.Level.TimeSeconds > 5) )
	{
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(Canvas.ClipX - (64*Scale), Canvas.ClipY / 2);
		Canvas.DrawIcon(texture'DisconnectWarn', Scale);
	}
}

function Timer()
{
	local int i, j;

	if (!bDrawMessageArea)
	{
		if (MessageFadeCount > 0)
			MessageFadeCount--;
	}

	// Age the short message queue.
	for (i=0; i<4; i++)
	{
		// Purge expired messages.
		if ( (ShortMessageQueue[i].Message != None) && (Level.TimeSeconds >= ShortMessageQueue[i].EndOfLife) )
			ClearMessage(ShortMessageQueue[i]);
	}

	// Clean empty slots.
	for (i=0; i<3; i++)
	{
		if ( ShortMessageQueue[i].Message == None )
		{
			for (j=i; j<4; j++)
			{
				if ( ShortMessageQueue[j].Message != None )
				{
					CopyMessage(ShortMessageQueue[i],ShortMessageQueue[j]);
					ClearMessage(ShortMessageQueue[j]);
					break;
				}
			}
		}
	}

	// Age all localized messages.
	for (i=0; i<10; i++)
	{
		// Purge expired messages.
		if ( (LocalMessages[i].Message != None) && (Level.TimeSeconds >= LocalMessages[i].EndOfLife) )
			ClearMessage(LocalMessages[i]);
	}

	// Clean empty slots.
	for (i=0; i<9; i++)
	{
		if ( LocalMessages[i].Message == None )
		{
			CopyMessage(LocalMessages[i],LocalMessages[i+1]);
			ClearMessage(LocalMessages[i+1]);
		}
	}

	if ( (PlayerOwner == None) || (PawnOwner == None) || (PlayerOwner.GameReplicationInfo == None)
		|| (PawnOwner.PlayerReplicationInfo == None) )
		return;
}

simulated function TellTime(int num)
{
	PlayerOwner.ReceiveLocalizedMessage( TimeMessageClass, Num );
}

simulated function Tick(float DeltaTime)
{
	local int i;

	Super.Tick(DeltaTime);

	IdentifyFadeTime = FMax(0.0, IdentifyFadeTime - DeltaTime);
	MOTDFadeOutTime = FMax(0.0, MOTDFadeOutTime - DeltaTime * 55);
	
	TutIconBlink += DeltaTime;
	if (TutIconBlink >= 0.5)
		TutIconBlink = 0.0;

	if ( bDrawFaceArea )
	{
		if ( FaceAreaOffset < 0 )
			FaceAreaOffset += DeltaTime * 600;
		if ( FaceAreaOffset > 0 )
			FaceAreaOffset = 0.0;
	} 
	else if ( FaceAreaOffset > MinFaceAreaOffset )
		FaceAreaOffset = FMax(FaceAreaOffset - DeltaTime * 600, MinFaceAreaOffset );

	if ( bDrawMessageArea )
	{
		if ( MessageFadeTime < 1.0 )
		{
			MessageFadeTime += DeltaTime * 8;
			if (MessageFadeTime > 1.0)
				MessageFadeTime = 1.0;
		}
	} 
	else if ( (MessageFadeTime > 0.0) && (MessageFadeCount == 0) )
	{
		MessageFadeTime -= DeltaTime * 2;
		if (MessageFadeTime < 0.0)
			MessageFadeTime = 0.0;
	}
}

simulated function DrawMOTD(Canvas Canvas)
{
	local GameReplicationInfo GRI;
	local float XL, YL;
	local float InitialY;

	GRI = PlayerPawn(Owner).GameReplicationInfo;
	if ( (GRI == None) || (GRI.GameName == "Game") || (MOTDFadeOutTime <= 0) ) 
		return;

	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.Style = Style;
	Canvas.bCenter = true;
	Canvas.DrawColor = UnitColor * MOTDFadeOutTime * 0.5;
	InitialY = 64*Scale;
	Canvas.SetPos(0.0, InitialY);
	Canvas.StrLen("TEST", XL, YL);
	if ( Level.NetMode != NM_Standalone )
	{
		Canvas.DrawText(GRI.ServerName);
		if ( Canvas.ClipY >= 300 )
		{
			Canvas.SetPos(0.0, InitialY + 6*YL);
			Canvas.DrawText(GRI.MOTDLine1, true);
			Canvas.SetPos(0.0, InitialY + 7*YL);
			Canvas.DrawText(GRI.MOTDLine2, true);
			Canvas.SetPos(0.0, InitialY + 8*YL);
			Canvas.DrawText(GRI.MOTDLine3, true);
			Canvas.SetPos(0.0, InitialY + 9*YL);
			Canvas.DrawText(GRI.MOTDLine4, true);
		}
	}
	Canvas.DrawColor = UnitColor * MOTDFadeOutTime * 0.6;
	Canvas.SetPos(0.0, InitialY + YL);
	Canvas.DrawText(GRI.GameName, true);
	Canvas.SetPos(0.0, InitialY + 2*YL);
	Canvas.DrawText(MapTitleString2@Level.Title, true);
	if ( Canvas.ClipY >= 300 )
	{
		Canvas.SetPos(0.0, InitialY + 3*YL);
		Canvas.DrawText(AuthorString2@Level.Author, true);
		if (Level.IdealPlayerCount != "")
		{
			Canvas.SetPos(0.0, InitialY + 4*YL);
			Canvas.DrawText(PlayerCountString$Level.IdealPlayerCount, true);
		}
	}
	Canvas.bCenter = false;
}

simulated function DrawCrossHair( canvas Canvas, int X, int Y)
{
	local float XScale, PickDiff;
	local float XLength;
	local texture T;

 	if (Crosshair>=CrosshairCount) Return;
	if ( Canvas.ClipX < 512 )
		XScale = 0.5;
	else
		XScale = FMax(1, int(0.1 + Canvas.ClipX/640.0));
	PickDiff = Level.TimeSeconds - PickupTime;
	if ( PickDiff < 0.4 )
	{
		if ( PickDiff < 0.2 )
			XScale *= (1 + 5 * PickDiff);
		else
			XScale *= (3 - 5 * PickDiff);
	}
	XLength = XScale * 64.0;

	Canvas.bNoSmooth = False;
	if ( PlayerOwner.Handedness == -1 )
		Canvas.SetPos(0.503 * (Canvas.ClipX - XLength), 0.504 * (Canvas.ClipY - XLength));
	else if ( PlayerOwner.Handedness == 1 )
		Canvas.SetPos(0.497 * (Canvas.ClipX - XLength), 0.496 * (Canvas.ClipY - XLength));
	else
		Canvas.SetPos(0.5 * (Canvas.ClipX - XLength), 0.5 * (Canvas.ClipY - XLength));
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = 15 * CrosshairColor;

	T = CrossHairTextures[Crosshair];
	if( T == None )
		T = LoadCrosshair(Crosshair);

	Canvas.DrawTile(T, XLength, XLength, 0, 0, 64, 64);
	Canvas.bNoSmooth = True;
	Canvas.Style = Style;
}

simulated function DrawTypingPrompt( canvas Canvas, console Console )
{
	local string TypingPrompt;
	local float XL, YL, YPos, XOffset;
	local float MyOldClipX, OldClipY, OldOrgX, OldOrgY;

	MyOldClipX = Canvas.ClipX;
	OldClipY = Canvas.ClipY;
	OldOrgX = Canvas.OrgX;
	OldOrgY = Canvas.OrgY;

	Canvas.DrawColor = GreenColor;
	TypingPrompt = "(>"@Console.TypedStr$"_";
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.StrLen( "TEST", XL, YL );
	YPos = YL*4 + 8;
	if (PawnOwner.PlayerReplicationInfo.bIsSpectator || bHideHUD || bHideFaces)
		XOffset = 0;
	else
		XOffset = FMax(0,FaceAreaOffset + 15*Scale + YPos);
	Canvas.SetOrigin(XOffset, FMax(0,YPos + 7*Scale));
	Canvas.SetClip( 760*Scale, Canvas.ClipY );
	Canvas.SetPos( 0, 0 );
	Canvas.DrawText( TypingPrompt, false );
	Canvas.SetOrigin( OldOrgX, OldOrgY );
	Canvas.SetClip( MyOldClipX, OldClipY );
}

// Entry point for string messages.
simulated function Message( PlayerReplicationInfo PRI, coerce string Msg, name MsgType )
{
	local int i;
	local Class<LocalMessage> MessageClass;

	switch (MsgType)
	{
		case 'Say':
		case 'TeamSay':
			MessageClass = class'SayMessagePlus';
			break;
		case 'CriticalEvent':
			MessageClass = class'CriticalStringPlus';
			LocalizedMessage( MessageClass, 0, None, None, None, Msg );
			return;
		case 'DeathMessage':
			MessageClass = class'RedSayMessagePlus';
			break;
		case 'Pickup':
			PickupTime = Level.TimeSeconds;
		default:
			MessageClass = class'StringMessagePlus';
			break;
	}

	if ( ClassIsChildOf(MessageClass, class'SayMessagePlus') || 
				     ClassIsChildOf(MessageClass, class'TeamSayMessagePlus') )
	{
		FaceTexture = PRI.TalkTexture;
		if ( FaceTexture != None )
			FaceTime = Level.TimeSeconds + 3;
		if ( Msg == "" )
			return;
	} 
	for (i=0; i<4; i++)
	{
		if ( ShortMessageQueue[i].Message == None )
		{
			// Add the message here.
			ShortMessageQueue[i].Message = MessageClass;
			ShortMessageQueue[i].Switch = 0;
			ShortMessageQueue[i].RelatedPRI = PRI;
			ShortMessageQueue[i].OptionalObject = None;
			ShortMessageQueue[i].EndOfLife = MessageClass.Default.Lifetime + Level.TimeSeconds;
			if ( MessageClass.Default.bComplexString )
				ShortMessageQueue[i].StringMessage = Msg;
			else
				ShortMessageQueue[i].StringMessage = MessageClass.Static.AssembleString(self,0,PRI,Msg);
			return;
		}
	}

	// No empty slots.  Force a message out.
	for (i=0; i<3; i++)
		CopyMessage(ShortMessageQueue[i], ShortMessageQueue[i+1]);

	ShortMessageQueue[3].Message = MessageClass;
	ShortMessageQueue[3].Switch = 0;
	ShortMessageQueue[3].RelatedPRI = PRI;
	ShortMessageQueue[3].OptionalObject = None;
	ShortMessageQueue[3].EndOfLife = MessageClass.Default.Lifetime + Level.TimeSeconds;
	if ( MessageClass.Default.bComplexString )
		ShortMessageQueue[3].StringMessage = Msg;
	else
		ShortMessageQueue[3].StringMessage = MessageClass.Static.AssembleString(self,0,PRI,Msg);
}

simulated function bool DisplayMessages( canvas Canvas )
{
	return true;
}

simulated function float DrawNextMessagePart(Canvas Canvas, string MString, float XOffset, int YPos)
{
	local float XL, YL;

	Canvas.SetPos(4 + XOffset, YPos);
	Canvas.StrLen( MString, XL, YL );
	Canvas.DrawText( MString, false );
	return (XOffset + XL);
}

//================================================================================
// Identify Info

simulated function bool TraceIdentify(canvas Canvas)
{
	local actor Other;
	local vector HitLocation, HitNormal, StartTrace, EndTrace;

	StartTrace = PawnOwner.Location;
	StartTrace.Z += PawnOwner.BaseEyeHeight;
	EndTrace = StartTrace + vector(PawnOwner.ViewRotation) * 1000.0;
	Other = Trace(HitLocation, HitNormal, EndTrace, StartTrace, true);

	if ( Pawn(Other) != None )
	{
		if ( Pawn(Other).bIsPlayer && !Other.bHidden )
		{
			//IdentifyTarget = Pawn(Other).PlayerReplicationInfo;
			IdentifyTarget = Pawn(Other);
			IdentifyFadeTime = 3.0;
		}
	}
	else if ( (Other != None) && SpecialIdentify(Canvas, Other) )
		return false;

	if ( (IdentifyFadeTime == 0.0) || (IdentifyTarget == None) )//|| PlayerPawn(IdentifyTarget).PlayerReplicationInfo.bFeigningDeath )
		return false;

	return true;
}

simulated function bool SpecialIdentify(Canvas Canvas, Actor Other )
{
	return false;
}

simulated function SetIDColor( Canvas Canvas, int type )
{
	Canvas.DrawColor = GreenColor;
	if ( type == 0 )
		Canvas.DrawColor.G = 160 * (IdentifyFadeTime / 3.0);
	else
		Canvas.DrawColor.G = 255 * (IdentifyFadeTime / 3.0);
}

simulated function DrawTwoColorID( canvas Canvas, string TitleString, string ValueString, int YStart )
{
	local float XL, YL, XOffset, X1;

	Canvas.Style = Style;
	Canvas.StrLen(TitleString$": ", XL, YL);
	X1 = XL;
	Canvas.StrLen(ValueString, XL, YL);
	XOffset = Canvas.ClipX/2 - (X1+XL)/2;
	Canvas.SetPos(XOffset, YStart);
	SetIDColor(Canvas,0);
	XOffset += X1;
	Canvas.DrawText(TitleString);
	Canvas.SetPos(XOffset, YStart);
	SetIDColor(Canvas,1);
	Canvas.DrawText("("@ValueString$")");
	Canvas.DrawColor = WhiteColor;
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
}
	
simulated function bool DrawIdentifyInfo(canvas Canvas)
{
	DrawMonsterName(Canvas);
	DrawWeaponOwner(Canvas);
	return true;
}

simulated function DrawMonsterName(Canvas C)
{
	
	local float Dist, XL, YL;
	local ScriptedPawn B;
	local int XPos, YPos;
	local Vector X,Y,Z, Dir;

	GetAxes(Owner.Rotation, X, Y, Z);
	C.Font = Font'WhiteFont';
	C.DrawColor = WhiteColor;
	C.Style = ERenderStyle.STY_Normal;

	foreach VisibleCollidingActors(class'ScriptedPawn', B, 1500, Owner.Location, true)//2000
		{
		Dir = B.Location - Owner.Location;
		Dist = VSize(Dir);
		Dir = Dir / Dist;
		C.StrLen(B.class.Name$"("$B.Health$")", XL, YL);
		if ((Dir Dot X) > 0.7)
			{
			XPos = 0.5 * C.ClipX * (1 + 1.4 * (Dir Dot Y));
			if (XPos < XL)
				{
				XPos = XL;
				}
			if (Xpos > C.ClipX - XL)
				{
				Xpos = C.ClipX - XL;
				}
			YPos = 0.5 * C.ClipY * (1 - 1.4 * (Dir Dot Z));
			C.SetPos(Xpos , YPos );
			C.DrawText(B.class.Name$"("$B.Health$")", true);
			}
		}
}

simulated function DrawWeaponOwner(Canvas C)
{	
local float Dist, XL, YL;
local Weap_biorifle BR;
local Weap_PulseGun PG;
local Weap_minigun2 MG;
local int XPos, YPos;
local Vector X,Y,Z, Dir;

	GetAxes(Owner.Rotation, X, Y, Z);
	C.Font = Font'WhiteFont';
	C.DrawColor = GreenColor;
	C.Style = ERenderStyle.STY_Normal;

	//Draw X Goo Gun
	foreach VisibleCollidingActors(class'Weap_biorifle', BR, 1500, Owner.Location, true)
		{
		Dir = BR.Location - Owner.Location;
		Dist = VSize(Dir);
		Dir = Dir / Dist;
		C.StrLen(BR.WeaponOwner$"'s Goo Gun", XL, YL);
		if ((Dir Dot X) > 0.7)
			{
			XPos = 0.5 * C.ClipX * (1 + 1.4 * (Dir Dot Y));
			if (XPos < XL)
				{
				XPos = XL;
				}
			if (Xpos > C.ClipX - XL)
				{
				Xpos = C.ClipX - XL;
				}
			YPos = 0.5 * C.ClipY * (1 - 1.4 * (Dir Dot Z));
			C.SetPos(Xpos , YPos );
			C.DrawText(BR.WeaponOwner$"'s Goo Gun", true);
			}
		}
	//Draw X PulseGun
	foreach VisibleCollidingActors(class'Weap_PulseGun', PG, 1500, Owner.Location, true)
		{
		Dir = PG.Location - Owner.Location;
		Dist = VSize(Dir);
		Dir = Dir / Dist;
		C.StrLen(PG.WeaponOwner$"'s PulseGun", XL, YL);
		if ((Dir Dot X) > 0.7)
			{
			XPos = 0.5 * C.ClipX * (1 + 1.4 * (Dir Dot Y));
			if (XPos < XL)
				{
				XPos = XL;
				}
			if (Xpos > C.ClipX - XL)
				{
				Xpos = C.ClipX - XL;
				}
			YPos = 0.5 * C.ClipY * (1 - 1.4 * (Dir Dot Z));
			C.SetPos(Xpos , YPos );
			C.DrawText(PG.WeaponOwner$"'s PulseGun", true);
			}
		}
	//Draw X minigun2
	foreach VisibleCollidingActors(class'Weap_minigun2', MG, 1500, Owner.Location, true)
		{
		Dir = MG.Location - Owner.Location;
		Dist = VSize(Dir);
		Dir = Dir / Dist;
		C.StrLen(MG.WeaponOwner$"'s minigun", XL, YL);
		if ((Dir Dot X) > 0.7)
			{
			XPos = 0.5 * C.ClipX * (1 + 1.4 * (Dir Dot Y));
			if (XPos < XL)
				{
				XPos = XL;
				}
			if (Xpos > C.ClipX - XL)
				{
				Xpos = C.ClipX - XL;
				}
			YPos = 0.5 * C.ClipY * (1 - 1.4 * (Dir Dot Z));
			C.SetPos(Xpos , YPos );
			C.DrawText(MG.WeaponOwner$"'s minigun", true);
			}
		}
	
}

//=====================================================================
// Deal with a localized message.

simulated function LocalizedMessage( class<LocalMessage> Message, optional int Switch, optional PlayerReplicationInfo RelatedPRI_1, optional PlayerReplicationInfo RelatedPRI_2, optional Object OptionalObject, optional String CriticalString )
{
	local int i;

	if ( ClassIsChildOf( Message, class'PickupMessagePlus' ) )
		PickupTime = Level.TimeSeconds;

	if ( !Message.Default.bIsSpecial )
	{
		if ( ClassIsChildOf(Message, class'SayMessagePlus') || 
						 ClassIsChildOf(Message, class'TeamSayMessagePlus') )
		{
			FaceTexture = RelatedPRI_1.TalkTexture;
			if ( FaceTexture != None )
				FaceTime = Level.TimeSeconds + 3;
		} 
		// Find an empty slot.
		for (i=0; i<4; i++)
		{
			if ( ShortMessageQueue[i].Message == None )
			{
				ShortMessageQueue[i].Message = Message;
				ShortMessageQueue[i].Switch = Switch;
				ShortMessageQueue[i].RelatedPRI = RelatedPRI_1;
				ShortMessageQueue[i].OptionalObject = OptionalObject;
				ShortMessageQueue[i].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
				if ( Message.Default.bComplexString )
					ShortMessageQueue[i].StringMessage = CriticalString;
				else
					ShortMessageQueue[i].StringMessage = Message.Static.GetString(Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);
				return;
			}

		}
		// No empty slots.  Force a message out.
		for (i=0; i<3; i++)
			CopyMessage(ShortMessageQueue[i], ShortMessageQueue[i+1]);

		ShortMessageQueue[3].Message = Message;
		ShortMessageQueue[3].Switch = Switch;
		ShortMessageQueue[3].RelatedPRI = RelatedPRI_1;
		ShortMessageQueue[3].OptionalObject = OptionalObject;
		ShortMessageQueue[3].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
		if ( Message.Default.bComplexString )
			ShortMessageQueue[3].StringMessage = CriticalString;
		else
			ShortMessageQueue[3].StringMessage = Message.Static.GetString(Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);
		return;
	} 
	else 
	{
		if ( CriticalString == "" )
			CriticalString = Message.Static.GetString(Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);
		if ( Message.Default.bIsUnique )
		{
			for (i=0; i<10; i++)
			{
				if (LocalMessages[i].Message != None)
				{
					if ((LocalMessages[i].Message == Message) 
						|| (LocalMessages[i].Message.Static.GetOffset(LocalMessages[i].Switch, 24, 640) 
								== Message.Static.GetOffset(Switch, 24, 640)) ) 
					{
						LocalMessages[i].Message = Message;
						LocalMessages[i].Switch = Switch;
						LocalMessages[i].RelatedPRI = RelatedPRI_1;
						LocalMessages[i].OptionalObject = OptionalObject;
						LocalMessages[i].LifeTime = Message.Default.Lifetime;
						LocalMessages[i].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
						LocalMessages[i].StringMessage = CriticalString;
						LocalMessages[i].DrawColor = Message.Static.GetColor(Switch, RelatedPRI_1, RelatedPRI_2);				
						LocalMessages[i].XL = 0;
						return;
					}
				}
			}
		}
		for (i=0; i<10; i++)
		{
			if (LocalMessages[i].Message == None)
			{
				LocalMessages[i].Message = Message;
				LocalMessages[i].Switch = Switch;
				LocalMessages[i].RelatedPRI = RelatedPRI_1;
				LocalMessages[i].OptionalObject = OptionalObject;
				LocalMessages[i].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
				LocalMessages[i].StringMessage = CriticalString;
				LocalMessages[i].DrawColor = Message.Static.GetColor(Switch, RelatedPRI_1, RelatedPRI_2);				
				LocalMessages[i].LifeTime = Message.Default.Lifetime;
				LocalMessages[i].XL = 0;
				return;
			}
		}

		// No empty slots.  Force a message out.
		for (i=0; i<9; i++)
			CopyMessage(LocalMessages[i],LocalMessages[i+1]);

		LocalMessages[9].Message = Message;
		LocalMessages[9].Switch = Switch;
		LocalMessages[9].RelatedPRI = RelatedPRI_1;
		LocalMessages[9].OptionalObject = OptionalObject;
		LocalMessages[9].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
		LocalMessages[9].StringMessage = CriticalString;
		LocalMessages[9].DrawColor = Message.Static.GetColor(Switch, RelatedPRI_1, RelatedPRI_2);				
		LocalMessages[9].LifeTime = Message.Default.Lifetime;
		LocalMessages[9].XL = 0;
		return;
	}
}

function string TwoDigitString(int Num)
{
	if ( Num < 10 )
		return "0"$Num;
	else
		return string(Num);
}

function DrawTimeInfo(Canvas Canvas )
{
	local int Hours, Minutes, Seconds;
	local float XL, YL;
	local PlayerPawn PlayerOwner;

	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	
	Canvas.DrawColor = WhiteColor;
	PlayerOwner = PlayerPawn(Owner);

	if ( PlayerOwner.GameReplicationInfo.RemainingTime > 0 )
		{
		if ( PlayerOwner.GameReplicationInfo.RemainingTime <= 0 )
			{
			Canvas.StrLen("00:00", XL, YL);
			Canvas.SetPos(Canvas.ClipX - XL - 1, 1);
			Canvas.DrawText("00:00", true);
			}
		else
			{
			Minutes = PlayerOwner.GameReplicationInfo.RemainingTime/60;
			Seconds = PlayerOwner.GameReplicationInfo.RemainingTime % 60;
			Canvas.StrLen(TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), XL, YL);
			Canvas.SetPos(Canvas.ClipX - XL - 1, 1);
			Canvas.DrawText(TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
			}
		}
	else
		{
		Seconds = PlayerOwner.GameReplicationInfo.ElapsedTime;
		Minutes = Seconds / 60;
		Hours   = Minutes / 60;
		Seconds = Seconds - (Minutes * 60);
		Minutes = Minutes - (Hours * 60);
		Canvas.StrLen(TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), XL, YL);
		Canvas.SetPos(Canvas.ClipX - XL - 1, 1);
		Canvas.DrawText(TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
		}
}

simulated function DrawRadar(Canvas C) 
{
	
	local float Dist;
	local ScriptedPawn P;
	local int XPos, YPos;
	local Vector X,Y,Z, Dir;
	
	GetAxes(Owner.Rotation, X, Y, Z);
	C.Font = Font'WhiteFont';
	C.Style = ERenderStyle.STY_Translucent;

	ShowRaderBase(C);
	ShowRadar(C);
}

simulated function ShowRaderBase(Canvas C) 
{
	
	local float RadarWidth, PulseWidth, PulseBrightness;

	C.Style = ERenderStyle.STY_Translucent;

	C.DrawColor = RadarColor;
	C.SetPos(C.ClipX - 142,C.ClipY * 0.5 - 64);
	C.DrawTile(Texture'Radar', 142, 142, 0, 0, 142, 142);
	
	C.DrawColor = WhiteColor;
	C.SetPos(C.ClipX - 142,C.ClipY * 0.5 - 64);
	C.DrawTile(Texture'RadarBorder', 142, 142, 0, 0, 142, 142);
}

simulated function ShowRadar(Canvas C) 
{
	
	local Pawn P;
	local float Dist, MaxDist, RadarWidth, PulseBrightness, Angle, DotSize, OffsetY, OffsetScale;
	local rotator Dir;
	local vector Start;
	
	LastDrawRadar = Level.TimeSeconds;

	DotSize = 6;

	if (PawnOwner == None)
		Start = PlayerOwner.Location;
	else
		Start = PawnOwner.Location;
	
	C.Style = ERenderStyle.STY_Translucent;
	
	foreach AllActors(class'Pawn', P)
		if (P.Health > 0 && (P.IsA('ScriptedPawn') || P.IsA('Bot') || P.IsA('TournamentPlayer')))
                        {
			
			Dist = VSize(Start - P.Location);
			if (Dist < 3000) {
				if (P.IsA('ScriptedPawn')) 
                                {
					C.DrawColor.R = 255;
					C.DrawColor.G = 0;
					C.DrawColor.B = 0;
				} 
                                else if (P.IsA('Bot') || P.IsA('TournamentPlayer')) 
                                {
					C.DrawColor.R = 0;
					C.DrawColor.B = 0;
					C.DrawColor.G = 255;
				}
				Dir = rotator(P.Location - Start);
				OffsetScale = 0.2 * Dist * 0.000167;
				Angle = ((Dir.Yaw - PlayerOwner.Rotation.Yaw) & 65535) * 6.2832 / 65536;
				C.SetPos(C.ClipX - 71 + OffsetScale * C.ClipX * sin(Angle) - 0.5 * DotSize,C.ClipY * 0.5 + 8 - OffsetScale * C.ClipY * cos(Angle) - 0.5 * DotSize);
				C.DrawTile(Texture'Dots', DotSize, DotSize, 0, 0, 16, 16);
			}
		}            
}


defaultproperties
{
     VersionMessage="Version"
     PlayerCountString="Base number of enemies:"
     MapTitleString="in"
     AuthorString="by"
     MapTitleString2="Map:"
     AuthorString2="Author:"
     RankString="Rank:"
     SpreadString="Spread:"
     CrosshairCount=9
     CrossHairs(0)="Botpack.CHair1"
     CrossHairs(1)="Botpack.CHair2"
     CrossHairs(2)="Botpack.CHair3"
     CrossHairs(3)="Botpack.CHair4"
     CrossHairs(4)="Botpack.CHair5"
     CrossHairs(5)="Botpack.CHair6"
     CrossHairs(6)="Botpack.CHair7"
     CrossHairs(7)="Botpack.CHair8"
     CrossHairs(8)="Botpack.CHair9"
     FP1(0)=Texture'Botpack.FacePanel.FacePanel1'
     FP1(1)=Texture'Botpack.FacePanel.FacePanel1b'
     FP1(2)=Texture'Botpack.FacePanel.FacePanel1a'
     FP2(0)=Texture'Botpack.FacePanel.FacePanel2'
     FP2(1)=Texture'Botpack.FacePanel.FacePanel2b'
     FP2(2)=Texture'Botpack.FacePanel.FacePanel2a'
     FP3(0)=Texture'Botpack.FacePanel.FacePanel3'
     FP3(1)=Texture'Botpack.FacePanel.FacePanel3b'
     FP3(2)=Texture'Botpack.FacePanel.FacePanel3a'
     Opacity=15
     HUDScale=1.000000
     StatusScale=1.000000
     WeaponScale=0.800000
     FavoriteHUDColor=(B=16)
     CrosshairColor=(G=16)
     Style=3
     WhiteColor=(R=255,G=255,B=255)
     RedColor=(R=255)
     GreenColor=(G=255)
     CyanColor=(G=255,B=255)
     UnitColor=(R=1,G=1,B=1)
     BlueColor=(B=255)
     GoldColor=(R=255,G=255)
     PurpleColor=(R=255,B=255)
     TurqColor=(G=128,B=255)
     GrayColor=(R=200,G=200,B=200)
     FaceColor=(R=50,G=50,B=50)
     RadarColor=(R=126,G=126,B=126)
     IdentifyName="Name:"
     IdentifyHealth="Health:"
     IdentifyCallsign="Callsign:"
     LiveFeed="Live Feed from "
     ScoreTime=-10000000.000000
     ServerInfoClass=Class'Botpack.ServerInfo'
     FontInfoClass="Botpack.FontInfo"
     mMinScale=0.300000
     mMaxScale=14.000000
}
